#include "game.h"

void IWRAM_CODE FlushPlayerBullet(int number)
{
	active_playerbullets--;

	sprites[active_playerbullets].attribute0 = SIZE_DOUBLE;
	sprites[active_playerbullets].attribute1 = 0;
	sprites[active_playerbullets].attribute2 = 0;

	if(number==active_playerbullets)
	{
		return;
	}

	sBullet* src = &playerbullets[active_playerbullets];
	sBullet* dst = &playerbullets[number];

	dst->xfixed = src->xfixed;
	dst->yfixed = src->yfixed;
	dst->xinc = src->xinc;
	dst->yinc = src->yinc;
	dst->x = src->x;
	dst->y = src->y;
}


void IWRAM_CODE FlushEnemyBullet(int number)
{
	active_enemybullets--;

	sprites[active_enemybullets+PLAYER_BULLETS].attribute0 = SIZE_DOUBLE;
	sprites[active_enemybullets+PLAYER_BULLETS].attribute1 = 0;
	sprites[active_enemybullets+PLAYER_BULLETS].attribute2 = 0;

	if(number==active_enemybullets)
	{
		return;
	}

	sBullet* src = &enemybullets[active_enemybullets];
	sBullet* dst = &enemybullets[number];

	dst->xfixed = src->xfixed;
	dst->yfixed = src->yfixed;
	dst->xinc = src->xinc;
	dst->yinc = src->yinc;
	dst->x = src->x;
	dst->y = src->y;
}

void IWRAM_CODE BulletsUpdate(void)
{
	int i;
	sBullet* b;
	if(active_playerbullets!=0)
	{
		for(i=0;i<active_playerbullets;i++)
		{
			b = &playerbullets[i];
			b->xfixed += b->xinc;
			b->yfixed += b->yinc;
			b->x = b->xfixed>>8;
			b->y = b->yfixed>>8;

			if(b->x<0 || b->x>239 || b->y<0 || b->y > 159) FlushPlayerBullet(i);
			else {
				int j;

				sprites[i].attribute0 = 0;
				sprites[i].attribute1 = 0;
				sprites[i].attribute2 = 513;
				MoveSprite(&sprites[i],b->x-2,b->y-1);

				for(j=0;j<active_enemies;j++)
				{
					sEnemy* e = &enemies[j];
					if(CheckModelCollision(&e->m,b->x,b->y))
					{
						if(!--e->hp) {
							//kramPlay(samples[SAMPLE_EXPLOSION],1,0);
							FlushEnemy(j);
							CreateRandomExplosionParticle(b->x,b->y);
							CreateRandomExplosionParticle(b->x,b->y);
							CreateRandomExplosionParticle(b->x,b->y);
							CreateRandomExplosionParticle(b->x,b->y);
							CreateRandomExplosionParticle(b->x,b->y);
							CreateRandomExplosionParticle(b->x,b->y);
							CreateRandomExplosionParticle(b->x,b->y);
							CreateRandomExplosionParticle(b->x,b->y);
						}

						CreateRandomExplosionParticle(b->x,b->y);
						CreateRandomExplosionParticle(b->x,b->y);
						CreateRandomExplosionParticle(b->x,b->y);
						CreateRandomExplosionParticle(b->x,b->y);

						FlushPlayerBullet(i--);
						break;
					}
				}
			}
		}
	}
	if(active_enemybullets!=0)
	{
		for(i=0;i<active_enemybullets;i++)
		{
			b = &enemybullets[i];
			b->xfixed += b->xinc;
			b->yfixed += b->yinc;
			b->x = b->xfixed>>8;
			b->y = b->yfixed>>8;

			if(b->x < 0 || b->x > 239 || b->y < 0 || b->y > 159) FlushEnemyBullet(i);
			else
			{
				if(CheckModelCollision(&player.m,b->x,b->y))
				{
					//kramPlay(samples[SAMPLE_EXPLOSION],1,0);
					CreateRandomExplosionParticle(b->x,b->y);
					CreateRandomExplosionParticle(b->x,b->y);
					CreateRandomExplosionParticle(b->x,b->y);
					CreateRandomExplosionParticle(b->x,b->y);
					CreateRandomExplosionParticle(b->x,b->y);
					CreateRandomExplosionParticle(b->x,b->y);
					CreateRandomExplosionParticle(b->x,b->y);
					CreateRandomExplosionParticle(b->x,b->y);
					FlushEnemyBullet(i--);
				}
				else
				{
					sprites[i+PLAYER_BULLETS].attribute0 = 0;
					sprites[i+PLAYER_BULLETS].attribute1 = 0;
					sprites[i+PLAYER_BULLETS].attribute2 = 512;
					MoveSprite(&sprites[i+PLAYER_BULLETS],b->x-2,b->y-1);
				}
			}
		}
	}
}

